/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.loot;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.loot.function.RetexturedLootFunction;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockLootTableProvider
extends BlockLoot {
    private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final LootItemCondition.Builder SHEARS = CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG);
    private static final LootItemCondition.Builder SILK_TOUCH_OR_SHEARS = SHEARS.m_7818_(SILK_TOUCH);

    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "tconstruct".equals(Objects.requireNonNull(block.getRegistryName()).m_135827_())).collect(Collectors.toList());
    }

    protected void addTables() {
        this.addCommon();
        this.addDecorative();
        this.addGadgets();
        this.addWorld();
        this.addTools();
        this.addSmeltery();
        this.addFoundry();
    }

    private void addCommon() {
        this.registerBuildingLootTables(TinkerCommons.blazewood);
        this.registerBuildingLootTables(TinkerCommons.lavawood);
        this.registerFenceBuildingLootTables(TinkerMaterials.nahuatl);
        this.m_124288_((Block)TinkerModifiers.silkyJewelBlock.get());
        this.m_124288_((Block)TinkerCommons.goldBars.get());
        this.m_124288_((Block)TinkerCommons.goldPlatform.get());
        this.m_124288_((Block)TinkerCommons.ironPlatform.get());
        this.m_124288_((Block)TinkerCommons.cobaltPlatform.get());
        TinkerCommons.copperPlatform.forEach(arg_0 -> ((BlockLootTableProvider)this).m_124288_(arg_0));
        TinkerCommons.waxedCopperPlatform.forEach(arg_0 -> ((BlockLootTableProvider)this).m_124288_(arg_0));
        this.m_124288_((Block)TinkerMaterials.cobalt.get());
        this.m_124288_((Block)TinkerMaterials.slimesteel.get());
        this.m_124288_((Block)TinkerMaterials.amethystBronze.get());
        this.m_124288_((Block)TinkerMaterials.roseGold.get());
        this.m_124288_((Block)TinkerMaterials.pigIron.get());
        this.m_124288_((Block)TinkerMaterials.manyullyn.get());
        this.m_124288_((Block)TinkerMaterials.hepatizon.get());
        this.m_124288_((Block)TinkerMaterials.queensSlime.get());
        this.m_124288_((Block)TinkerMaterials.soulsteel.get());
        this.m_124288_((Block)TinkerMaterials.knightslime.get());
    }

    private void addDecorative() {
        this.m_124288_((Block)TinkerCommons.obsidianPane.get());
        this.m_124288_((Block)TinkerCommons.clearGlass.get());
        this.m_124288_((Block)TinkerCommons.clearTintedGlass.get());
        this.m_124288_((Block)TinkerCommons.clearGlassPane.get());
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            this.m_124288_((Block)TinkerCommons.clearStainedGlass.get((Enum)color));
            this.m_124288_((Block)TinkerCommons.clearStainedGlassPane.get((Enum)color));
        }
        this.m_124288_((Block)TinkerCommons.soulGlass.get());
        this.m_124288_((Block)TinkerCommons.soulGlassPane.get());
        this.registerBuildingLootTables(TinkerCommons.mudBricks);
    }

    private void addTools() {
        this.m_124175_((Block)TinkerTables.tinkersChest.get(), block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("color", "display.color"))));
        this.m_124175_((Block)TinkerTables.partChest.get(), block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY))));
        this.m_124175_((Block)TinkerTables.castChest.get(), block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Items", "TinkerData.Items"))));
        Function<Block, LootTable.Builder> addTable = block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_(RetexturedLootFunction::new));
        this.m_124175_((Block)TinkerTables.craftingStation.get(), addTable);
        this.m_124175_((Block)TinkerTables.partBuilder.get(), addTable);
        this.m_124175_((Block)TinkerTables.tinkerStation.get(), addTable);
        this.m_124175_((Block)TinkerTables.tinkersAnvil.get(), addTable);
        this.m_124175_((Block)TinkerTables.scorchedAnvil.get(), addTable);
    }

    private void addWorld() {
        this.m_124175_((Block)TinkerWorld.cobaltOre.get(), block -> BlockLootTableProvider.m_124139_((Block)block, (Item)TinkerWorld.rawCobalt.m_5456_()));
        this.m_124288_((Block)TinkerWorld.rawCobaltBlock.get());
        TinkerWorld.heads.forEach(arg_0 -> ((BlockLootTableProvider)this).m_124288_(arg_0));
        TinkerWorld.slime.forEach((type, block) -> {
            if (type != SlimeType.EARTH) {
                this.m_124288_((Block)block);
            }
        });
        TinkerWorld.congealedSlime.forEach((slime, block) -> this.m_124165_((Block)block, BlockLootTableProvider.m_176042_((Block)block, (ItemLike)((ItemLike)TinkerCommons.slimeball.get((Enum)slime)), (NumberProvider)ConstantValue.m_165692_((float)4.0f))));
        TinkerWorld.slimeDirt.forEach(arg_0 -> ((BlockLootTableProvider)this).m_124288_(arg_0));
        TinkerWorld.vanillaSlimeGrass.forEach(block -> this.m_124165_((Block)block, BlockLootTableProvider.m_124257_((Block)block, (ItemLike)Blocks.f_50493_)));
        TinkerWorld.earthSlimeGrass.forEach(block -> this.m_124165_((Block)block, BlockLootTableProvider.m_124257_((Block)block, (ItemLike)((ItemLike)TinkerWorld.slimeDirt.get((Enum)SlimeType.EARTH)))));
        TinkerWorld.skySlimeGrass.forEach(block -> this.m_124165_((Block)block, BlockLootTableProvider.m_124257_((Block)block, (ItemLike)((ItemLike)TinkerWorld.slimeDirt.get((Enum)SlimeType.SKY)))));
        TinkerWorld.enderSlimeGrass.forEach(block -> this.m_124165_((Block)block, BlockLootTableProvider.m_124257_((Block)block, (ItemLike)((ItemLike)TinkerWorld.slimeDirt.get((Enum)SlimeType.ENDER)))));
        TinkerWorld.ichorSlimeGrass.forEach(block -> this.m_124165_((Block)block, BlockLootTableProvider.m_124257_((Block)block, (ItemLike)((ItemLike)TinkerWorld.slimeDirt.get((Enum)SlimeType.ICHOR)))));
        TinkerWorld.slimeSapling.forEach(arg_0 -> ((BlockLootTableProvider)this).m_124288_(arg_0));
        TinkerWorld.slimeTallGrass.forEach(block -> this.m_124175_((Block)block, BlockLootTableProvider::onlyShears));
        for (SlimeType type2 : SlimeType.OVERWORLD) {
            this.m_124175_((Block)TinkerWorld.slimeLeaves.get((Enum)type2), block -> BlockLootTableProvider.randomDropSlimeBallOrSapling(type2, block, (Block)TinkerWorld.slimeSapling.get((Enum)type2), f_124068_));
            this.m_124175_((Block)TinkerWorld.slimeFern.get((Enum)type2), BlockLootTableProvider::onlyShears);
        }
        for (SlimeType type2 : SlimeType.NETHER) {
            this.m_124288_((Block)TinkerWorld.slimeLeaves.get((Enum)type2));
            this.m_124288_((Block)TinkerWorld.slimeFern.get((Enum)type2));
        }
        this.m_124175_((Block)TinkerWorld.skySlimeVine.get(), BlockLootTableProvider::onlyShears);
        this.m_124175_((Block)TinkerWorld.enderSlimeVine.get(), BlockLootTableProvider::onlyShears);
        this.registerWoodLootTables(TinkerWorld.greenheart);
        this.registerWoodLootTables(TinkerWorld.skyroot);
        this.registerWoodLootTables(TinkerWorld.bloodshroom);
        this.registerGeode(TinkerWorld.earthGeode);
        this.registerGeode(TinkerWorld.skyGeode);
        this.registerGeode(TinkerWorld.ichorGeode);
        this.registerGeode(TinkerWorld.enderGeode);
    }

    private void addGadgets() {
        this.m_124288_((Block)TinkerGadgets.punji.get());
        TinkerGadgets.cake.forEach(block -> this.m_124165_((Block)block, BlockLootTableProvider.m_124125_()));
        this.m_124165_((Block)TinkerGadgets.magmaCake.get(), BlockLootTableProvider.m_124125_());
    }

    private void addSmeltery() {
        this.m_124288_((Block)TinkerSmeltery.grout.get());
        this.m_124288_((Block)TinkerSmeltery.searedMelter.get());
        this.m_124288_((Block)TinkerSmeltery.searedHeater.get());
        this.m_124288_((Block)TinkerSmeltery.smelteryController.get());
        this.registerBuildingLootTables(TinkerSmeltery.searedStone);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedCobble);
        this.registerBuildingLootTables(TinkerSmeltery.searedPaver);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedBricks);
        this.m_124288_((Block)TinkerSmeltery.searedCrackedBricks.get());
        this.m_124288_((Block)TinkerSmeltery.searedFancyBricks.get());
        this.m_124288_((Block)TinkerSmeltery.searedTriangleBricks.get());
        this.m_124288_((Block)TinkerSmeltery.searedLadder.get());
        this.m_124288_((Block)TinkerSmeltery.searedGlass.get());
        this.m_124288_((Block)TinkerSmeltery.searedGlassPane.get());
        this.m_124288_((Block)TinkerSmeltery.searedDrain.get());
        this.m_124288_((Block)TinkerSmeltery.searedChute.get());
        this.m_124288_((Block)TinkerSmeltery.searedDuct.get());
        Function<Block, LootTable.Builder> dropTank = block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("tank", "tank")));
        TinkerSmeltery.searedTank.forEach(block -> this.m_124175_((Block)block, dropTank));
        this.m_124175_((Block)TinkerSmeltery.searedLantern.get(), dropTank);
        this.m_124288_((Block)TinkerSmeltery.searedFaucet.get());
        this.m_124288_((Block)TinkerSmeltery.searedChannel.get());
        this.m_124288_((Block)TinkerSmeltery.searedBasin.get());
        this.m_124288_((Block)TinkerSmeltery.searedTable.get());
    }

    private void addFoundry() {
        this.m_124288_((Block)TinkerSmeltery.netherGrout.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedAlloyer.get());
        this.m_124288_((Block)TinkerSmeltery.foundryController.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedStone.get());
        this.m_124288_((Block)TinkerSmeltery.polishedScorchedStone.get());
        this.registerFenceBuildingLootTables(TinkerSmeltery.scorchedBricks);
        this.m_124288_((Block)TinkerSmeltery.chiseledScorchedBricks.get());
        this.registerBuildingLootTables(TinkerSmeltery.scorchedRoad);
        this.m_124288_((Block)TinkerSmeltery.scorchedLadder.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedGlass.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedGlassPane.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedDrain.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedChute.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedDuct.get());
        Function<Block, LootTable.Builder> dropTank = block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("tank", "tank")));
        TinkerSmeltery.scorchedTank.forEach(block -> this.m_124175_((Block)block, dropTank));
        this.m_124175_((Block)TinkerSmeltery.scorchedLantern.get(), dropTank);
        this.m_124288_((Block)TinkerSmeltery.scorchedFaucet.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedChannel.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedBasin.get());
        this.m_124288_((Block)TinkerSmeltery.scorchedTable.get());
    }

    protected static LootTable.Builder onlyShears(ItemLike item) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(SHEARS).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item)));
    }

    private static LootTable.Builder droppingSilkOrShears(Block block, LootPoolEntryContainer.Builder<?> alternativeLootEntry) {
        return BlockLootTableProvider.m_124171_((Block)block, (LootItemCondition.Builder)SILK_TOUCH_OR_SHEARS, alternativeLootEntry);
    }

    private static LootTable.Builder dropSapling(Block blockIn, Block saplingIn, float ... fortuneIn) {
        return BlockLootTableProvider.droppingSilkOrShears(blockIn, ((LootPoolSingletonContainer.Builder)BlockLootTableProvider.m_124134_((ItemLike)blockIn, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)saplingIn))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])fortuneIn)));
    }

    private static LootTable.Builder randomDropSlimeBallOrSapling(SlimeType foliageType, Block blockIn, Block sapling, float ... fortuneIn) {
        return BlockLootTableProvider.dropSapling(blockIn, sapling, fortuneIn).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(f_124066_).m_79076_(((LootPoolSingletonContainer.Builder)BlockLootTableProvider.m_124134_((ItemLike)blockIn, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)TinkerCommons.slimeball.get((Enum)foliageType))))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.05f}))));
    }

    private static LootTable.Builder droppingWithFunctions(Block block, Function<LootPoolSingletonContainer.Builder<?>, LootPoolSingletonContainer.Builder<?>> mapping) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLootTableProvider.m_124134_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)mapping.apply(LootItem.m_79579_((ItemLike)block)))));
    }

    private void registerBuildingLootTables(BuildingBlockObject object) {
        this.m_124288_((Block)object.get());
        this.m_124175_((Block)object.getSlab(), x$0 -> BlockLoot.m_124290_((Block)x$0));
        this.m_124288_((Block)object.getStairs());
    }

    private void registerWallBuildingLootTables(WallBuildingBlockObject object) {
        this.registerBuildingLootTables((BuildingBlockObject)object);
        this.m_124288_((Block)object.getWall());
    }

    private void registerFenceBuildingLootTables(FenceBuildingBlockObject object) {
        this.registerBuildingLootTables((BuildingBlockObject)object);
        this.m_124288_((Block)object.getFence());
    }

    private void registerWoodLootTables(WoodBlockObject object) {
        this.registerFenceBuildingLootTables((FenceBuildingBlockObject)object);
        this.m_124288_(object.getLog());
        this.m_124288_(object.getStrippedLog());
        this.m_124288_(object.getWood());
        this.m_124288_(object.getStrippedWood());
        this.m_124288_((Block)object.getFenceGate());
        this.m_124175_((Block)object.getDoor(), BlockLoot::m_124137_);
        this.m_124288_((Block)object.getTrapdoor());
        this.m_124288_((Block)object.getPressurePlate());
        this.m_124288_((Block)object.getButton());
        this.m_124288_((Block)object.getSign());
    }

    private void registerGeode(GeodeItemObject geode) {
        this.m_124288_(geode.getBlock());
        this.m_124175_(geode.getBud(GeodeItemObject.BudSize.CLUSTER), block -> BlockLootTableProvider.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)geode.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_144323_)))).m_7170_((LootPoolEntryContainer.Builder)BlockLootTableProvider.m_124131_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)geode.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)))))));
        for (GeodeItemObject.BudSize size : GeodeItemObject.BudSize.SIZES) {
            this.m_124272_(geode.getBud(size));
        }
        this.m_124165_(geode.getBudding(), BlockLootTableProvider.m_124125_());
    }
}

